﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class ExerciseAvatar : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.ExerciseAvatar, BO.ExerciseAvatar>
    {

        internal ExerciseAvatar(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal ExerciseAvatar(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.ExerciseAvatar.DBD) { }

        internal BO.ExerciseAvatar RestoreRandom(BO.ExerciseAvatar.Search Search)
        {
            return InternalRestoreOne((int)DBD.ExerciseAvatar.Commands.RestoreRandomBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ExerciseEventID"].Value = Search.ExerciseEventID;
                Command["ExerciseTypeID"].Value = Search.ExerciseTypeID;
            });
        }

        internal List<BO.ExerciseAvatar> Restore(BO.ExerciseAvatar.Search Search)
        {
            return InternalRestoreList((int)DBD.ExerciseAvatar.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ExerciseEventID"].Value = Search.ExerciseEventID;
                Command["ExerciseTypeID"].Value = Search.ExerciseTypeID;
            });
        }
    }
}
